<?php

namespace KeyDesign;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

$license_key = License\Admin::get_license_key();

if ( ! $license_key ) {
    return;
}

$license_data = License\API::get_license_data();
$support_status = false;
$support_message = '';
$disable_button = false;
$support_remaining = '';
$keydesign_support_expiry_time = get_option( 'keydesign_support_expiry_time', '' );
$keydesign_support_update_flag = get_option( 'keydesign_support_update_flag', false );

if ( isset( $_GET['refresh_support'] ) && sanitize_text_field( $_GET['refresh_support'] ) === 'true' ) {
    check_my_support_status();

    // Reload the updated value of keydesign_support_expiry_time
    $keydesign_support_expiry_time = get_option( 'keydesign_support_expiry_time', '' );
}

if ( $license_data['status'] ) {
    $support_expiry = $license_data['data'];

    $current_time = current_time( 'timestamp' );
    $expiry_time = strtotime( $support_expiry );

    // Check if the flag is not set
    if ( ! $keydesign_support_update_flag ) {
        // Update the expiry time and set the flag
        update_option( 'keydesign_support_expiry_time', $expiry_time );
        update_option( 'keydesign_support_update_flag', true );
        $keydesign_support_expiry_time = $expiry_time; // Update the local variable
        $keydesign_support_update_flag = true; // Update the local flag
    }

    $support_remaining = human_time_diff( $current_time, $keydesign_support_expiry_time );

    if ( $keydesign_support_expiry_time > $current_time ) {
        $support_status = true;

        // Calculate the difference in months
        $diff_in_seconds = $keydesign_support_expiry_time - $current_time;
        $diff_in_months = $diff_in_seconds / (30 * 24 * 60 * 60); // 30 days * 24 hours * 60 minutes * 60 seconds

        if ( $diff_in_months > 6 ) {
            $support_message = esc_html__( 'Thanks for securing your website with extended support.', 'keydesign-framework' );
            $disable_button = true; // Disable the buttons
        }
    }
}

function check_my_support_status() {
    $license_key = License\Admin::get_license_key();
    if ( ! $license_key ) {
        return;
    }

        $last_refresh_time = get_option( 'keydesign_last_refresh_time', 0 );
        $current_time = current_time( 'timestamp' );
        $cooldown_period = 30;
        if ( $current_time - $last_refresh_time < $cooldown_period ) {
            // echo esc_html__( 'Please wait ', 'keydesign-framework' ) . human_time_diff( $current_time, $last_refresh_time + $cooldown_period ) . esc_html__( ' before refreshing again.', 'keydesign-framework' );
            return;
        }

        update_option( 'keydesign_last_refresh_time', $current_time );

    define( 'KEYDESIGN_SUPPORT_URL', 'https://my.keydesign.xyz/support.php' );
    $my_support_url = add_query_arg( 'purchase_code', urlencode( $license_key ), KEYDESIGN_SUPPORT_URL );

    $my_support_response = wp_remote_get( $my_support_url, [ 'timeout' => 10 ] );

    if ( is_wp_error( $my_support_response ) ) {
        echo "Error: " . $my_support_response->get_error_message();
    } else {
        $my_support_body = wp_remote_retrieve_body( $my_support_response );
        $envato_api_new_time = strtotime( $my_support_body );

        if ( $envato_api_new_time ) {
            update_option( 'keydesign_support_expiry_time', $envato_api_new_time );
        } 
    }
}


?>
<div class="kdadmin-panel-column">
    <h3>
        <span class="dashboard-icon lnricons-lifebuoy"></span>
        <?php echo esc_html__( 'Support Status', 'keydesign-framework' ); ?>
        <a href="<?php echo esc_url( add_query_arg( 'refresh_support', 'true' ) ); ?>" class="kdadmin-refresh-button">
        <span class="dashicons dashicons-update"></span>
    </a>
    </h3>

    <p>
        <?php if ( $support_status ) : ?>
            <span class="active">
                <?php printf( esc_html__( 'Your item support will expire in %1$s.', 'keydesign-framework' ), $support_remaining ); ?>
            </span>
        <?php else : ?>
            <span class="expired">
                <?php echo esc_html__( 'Your support subscription has expired.', 'keydesign-framework' ); ?>
            </span>
        <?php endif; ?>
    </p>

    <hr>

    <?php if ( $support_status ) : ?>
        <?php if ( ! empty( $support_message ) ) : ?>
            <p><?php echo $support_message; ?></p>
        <?php else : ?>
            <p><?php echo esc_html__( 'Get an extra 6 months of support now and save.', 'keydesign-framework' ); ?></p>
        <?php endif; ?>
        <span class="support-badge active"><?php echo esc_html__( 'Active', 'keydesign-framework' ); ?></span>
    <?php else : ?>
        <p><?php echo esc_html__( 'Renew your support for 6 new months.', 'keydesign-framework' ); ?></p>
        <span class="support-badge expired"><?php echo esc_html__( 'Expired', 'keydesign-framework' ); ?></span>
    <?php endif; ?>

    <?php if ( defined( 'KEYDESIGN_THEMEFOREST_THEME_LINK' ) && ! $disable_button ) : ?>
        <a class="kdadmin-button support-button" href="<?php echo esc_attr( KEYDESIGN_THEMEFOREST_THEME_LINK ); ?>" target="_blank">
            <?php if ( $support_status ) : ?>
                <?php echo esc_html__( 'Extend support', 'keydesign-framework' ); ?>
            <?php else : ?>
                <?php echo esc_html__( 'Renew support', 'keydesign-framework' ); ?>
            <?php endif; ?>
        </a>
    <?php endif; ?>
</div>